/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.network;

import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.ribbits.client.sound.PlayerInstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.client.sound.RibbitInstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.client.supporters.RibbitOptionsJSON;
import com.yungnickyoung.minecraft.ribbits.client.supporters.SupportersListClient;
import com.yungnickyoung.minecraft.ribbits.data.RibbitInstrument;
import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.mixin.interfaces.client.ISoundManagerDuck;
import com.yungnickyoung.minecraft.ribbits.mixin.mixins.client.accessor.ClientLevelAccessor;
import com.yungnickyoung.minecraft.ribbits.module.RibbitInstrumentModule;
import com.yungnickyoung.minecraft.ribbits.module.SoundModule;
import com.yungnickyoung.minecraft.ribbits.network.packet.RequestSupporterHatStatePacket;
import com.yungnickyoung.minecraft.ribbits.network.packet.ToggleSupporterPacket;
import com.yungnickyoung.minecraft.ribbits.services.Services;
import com.yungnickyoung.minecraft.ribbits.util.BufferUtils;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_634;
import net.minecraft.class_746;

public class ClientPacketHandlerFabric {
    public static void receiveStartSingle(class_310 client, class_634 clientPacketListener, class_2540 buf, PacketSender responseSender) {
        UUID entityId = buf.method_10790();
        RibbitEntity ribbit = (RibbitEntity)((ClientLevelAccessor)client.field_1687).callGetEntities().method_31808(entityId);
        RibbitInstrument instrument = RibbitInstrumentModule.getInstrument(buf.method_10810());
        int tickOffset = buf.readInt();
        if (ribbit == null) {
            RibbitsCommon.LOGGER.error("Received Start Music packet for a ribbit with UUID {} that doesn't exist!", (Object)entityId);
            return;
        }
        if (instrument == null) {
            RibbitsCommon.LOGGER.error("Tried to play music for a ribbit with null instrument!");
            return;
        }
        if (instrument == RibbitInstrumentModule.NONE) {
            RibbitsCommon.LOGGER.error("Tried to play music for a ribbit with NONE instrument!");
            return;
        }
        class_3414 instrumentSoundEvent = instrument.getSoundEvent();
        client.execute(() -> class_310.method_1551().method_1483().method_4873((class_1113)new RibbitInstrumentSoundInstance(ribbit, tickOffset, instrumentSoundEvent)));
    }

    public static void receiveStartAll(class_310 client, class_634 clientPacketListener, class_2540 buf, PacketSender responseSender) {
        List<UUID> entityIds = BufferUtils.readUUIDList(buf);
        List<class_2960> instrumentIds = BufferUtils.readResourceLocationList(buf);
        int tickOffset = buf.readInt();
        if (entityIds.size() != instrumentIds.size()) {
            RibbitsCommon.LOGGER.error("Received Start Music All packet with {} ribbits and {} instruments!", (Object)entityIds.size(), (Object)instrumentIds.size());
            return;
        }
        for (int i = 0; i < entityIds.size(); ++i) {
            RibbitEntity ribbit = (RibbitEntity)((ClientLevelAccessor)client.field_1687).callGetEntities().method_31808(entityIds.get(i));
            if (ribbit == null) {
                RibbitsCommon.LOGGER.error("Received Start Music All packet for a ribbit with UUID {} that doesn't exist!", (Object)entityIds.get(i));
                return;
            }
            RibbitInstrument instrument = RibbitInstrumentModule.getInstrument(instrumentIds.get(i));
            if (instrument == null) {
                RibbitsCommon.LOGGER.error("Tried to play music in receiveStartAll for a ribbit with null instrument!");
                return;
            }
            if (instrument == RibbitInstrumentModule.NONE) {
                RibbitsCommon.LOGGER.error("Tried to play music in receiveStartAll for a ribbit with NONE instrument!");
                return;
            }
            class_3414 instrumentSoundEvent = instrument.getSoundEvent();
            client.execute(() -> class_310.method_1551().method_1483().method_4873((class_1113)new RibbitInstrumentSoundInstance(ribbit, tickOffset, instrumentSoundEvent)));
        }
    }

    public static void receiveStop(class_310 client, class_634 clientPacketListener, class_2540 buf, PacketSender responseSender) {
        UUID entityId = buf.method_10790();
        RibbitEntity ribbit = (RibbitEntity)((ClientLevelAccessor)client.field_1687).callGetEntities().method_31808(entityId);
        if (ribbit == null) {
            RibbitsCommon.LOGGER.error("Received Stop Music packet for a ribbit with UUID {} that doesn't exist!", (Object)entityId);
            return;
        }
        client.execute(() -> ((ISoundManagerDuck)class_310.method_1551().method_1483()).ribbits$stopRibbitsMusic(entityId));
    }

    public static void receiveStartMaraca(class_310 client, class_634 clientPacketListener, class_2540 buf, PacketSender responseSender) {
        UUID performerId = buf.method_10790();
        class_1297 performer = (class_1297)((ClientLevelAccessor)client.field_1687).callGetEntities().method_31808(performerId);
        if (performer == null) {
            RibbitsCommon.LOGGER.error("Received Start Maraca packet for Player performer with UUID {} that doesn't exist!", (Object)performerId);
            return;
        }
        if (!(performer instanceof class_1657)) {
            RibbitsCommon.LOGGER.error("Received Start Maraca packet for non-Player performer with UUID {}!", (Object)performerId);
            return;
        }
        client.execute(() -> class_310.method_1551().method_1483().method_4873((class_1113)new PlayerInstrumentSoundInstance((class_1657)performer, -1, (class_3414)SoundModule.MUSIC_MARACA.get())));
    }

    public static void receiveStopMaraca(class_310 client, class_634 clientPacketListener, class_2540 buf, PacketSender responseSender) {
        UUID performerId = buf.method_10790();
        class_1297 performer = (class_1297)((ClientLevelAccessor)client.field_1687).callGetEntities().method_31808(performerId);
        if (performer == null) {
            RibbitsCommon.LOGGER.error("Received Stop Maraca packet for Player performer with UUID {} that doesn't exist!", (Object)performerId);
            return;
        }
        if (!(performer instanceof class_1657)) {
            RibbitsCommon.LOGGER.error("Received Stop Maraca packet for non-Player performer with UUID {}!", (Object)performerId);
            return;
        }
        client.execute(() -> ((ISoundManagerDuck)class_310.method_1551().method_1483()).ribbits$stopMaraca(performerId));
    }

    public static void receiveToggleSupporterHat(ToggleSupporterPacket packet, class_746 player, PacketSender responseSender) {
        SupportersListClient.toggleSupporterHat(packet.playerUUID(), packet.enabled());
    }

    public static void receiveSupporterHatStateRequest(RequestSupporterHatStatePacket packet, class_746 player, PacketSender responseSender) {
        SupportersListClient.clear();
        packet.enabledSupporterHatPlayers().forEach(playerUUID -> SupportersListClient.toggleSupporterHat(playerUUID, true));
        Services.SUPPORTER_HELPER.notifyServerOfSupporterHatState(RibbitOptionsJSON.get().isSupporterHatEnabled());
    }
}

